/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.scriptconsole;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LoggingOutputStream
extends ByteArrayOutputStream {
    private final String lineSeparator;
    private final Logger logger;
    private final Level level;

    public LoggingOutputStream(Logger logger, Level level) {
        this.logger = logger;
        this.level = level;
        this.lineSeparator = System.getProperty("line.separator");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws IOException {
        LoggingOutputStream loggingOutputStream = this;
        synchronized (loggingOutputStream) {
            String[] ss;
            String record;
            super.flush();
            try {
                record = this.toString("ISO-8859-1");
            }
            catch (UnsupportedEncodingException ex) {
                record = this.toString();
            }
            if (!record.contains(this.lineSeparator)) {
                return;
            }
            super.reset();
            if (record.length() == 0 || record.equals(this.lineSeparator)) {
                return;
            }
            for (String s : ss = record.split("\n")) {
                this.logger.logp(this.level, "", "", s);
            }
        }
    }
}

